#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

static int secret_value;
static int random_num;

// Function prototypes
void init(void);
void print_flag(void);
int check_secret(const char *input);

int main() {
    char input[64];

    init();

    printf("\nEnter the secret: ");
    if (fgets(input, sizeof(input), stdin) == NULL) {
        printf("Error reading input.\n");
        return 1;
    }

    // Remove newline character from input
    input[strlen(input) - 1] = '\0';

    if (check_secret(input)) {
        print_flag();
    } else {
        printf("Wrong secret!\n");
    }

    return 0;
}

// Handles flag file reading and display
void print_flag(void) {
    FILE *flag_file = fopen("/opt/flag.txt", "r");
    char flag[256];

    if (flag_file == NULL) {
        printf("Flag: %s\n", "WE FORGOT THE FLAG, SORRY :(");
    } else {
        if (fgets(flag, sizeof(flag), flag_file) != NULL) {
            printf("Flag: %s\n", flag);
        } else {
            printf("Flag file is empty or error reading it.\n");
        }
        fclose(flag_file);
    }
}

void init() {
    // 1. Generate random number
    srand(time(NULL));
    random_num = rand() % 10 + 1;
    printf("My random number: %d\n", random_num);

    // 2. Get current date and time
    time_t now = time(NULL);
    struct tm *tm_info = localtime(&now);
    char date_str[20];
    strftime(date_str, 20, "%Y-%m-%d %H:%M", tm_info);
    printf("Current date: %s\n", date_str);

    // 3. Calculate secret formula
    int sum = (tm_info->tm_year + 1900) +  // Year
              (tm_info->tm_mon + 1) +      // Month
              tm_info->tm_mday +           // Day
              tm_info->tm_hour +           // Hour
              tm_info->tm_min;             // Minute
    
    secret_value = sum * random_num;
}

int check_secret(const char *input) {
    char secret_str[20];
    snprintf(secret_str, sizeof(secret_str), "%d", secret_value);
    //printf("Secret value: '%d'\n", secret_value);
    //printf("Input value: '%s'\n", input);
    return strcmp(input, secret_str) == 0;
}